#! /usr/bin/python2.7
"""
                        PC-Soundkarte als selektiver Pegelmesser

Gemessen wird ueber die Standard-Soundkarte, unter Linux einstellbar in PulseAudio.

Lueckenlose Verarbeitung des Stereo-Datenstromes in Bloecken von "Multi-Chunks",
wobei 1 chunk 1024 Stereo-Samples beinhaltet. Diese Bloecke werden von der 
Soundkarte per callback geliefert, innerhalb der callback-Funktion zusammengesetzt 
und nach Fertigstellung vom Hauptprogramm per polling abgeholt.  
Verpasst das Hauptprogramm einen Datenblock, gibt es eine Fehlermeldung in der Konsole.

Zur Minimierung der CPU-Last wird das polling durch eingeschobene sleep-Zeiten ausgeduennt.

Butterworth Bandpass-Filterung des StereoDatenstromes,
parametriert ueber die beiden -3dB Frequenz-Eckpunkte und die Filterordnung.
Dies erhoeht den ausnutzbaren Dynamikbereich um mehrere 10dB.

Mittel-/EffektivWert Berechnungen, pro Wert gemittelt ueber einen vollen Multi-chunk
Normiert wird auf 0dB = 100%-Aussteuerung digital.
Die tatsaechliche Aussteuergrenze der Behringer UCA-202 liegt 2dB darunter.

Stereo Balkenzeige: 
limit2 - top:    rot
limit1 - limit2: gelb
bottom - limit1: gruen
Die limits werden gesetzt auf z.B -30 und -50dB

Bildwiederholrate: ca 15FPS (Abtastrate=41.1kHz Chunkbuffers=3, auf lenovo G780)
FPS = SampleRate/MultiChunkSize = 44,1kHz/(3x1024) = 14,36FPS
ProzessorLast: 5% bei 15FPS auf Lenocvo G780
MaxRechenzeit HauptPgmSchleife: 42ms (44,1kHz, Lenovo G780)

Bildschirmauffrischung und Messung sind synchron, 
also ist die Messrate gleich der Bildschirmwiederholrate.

Abspeicherung der Effektivwerte in zwei csv-Dateien (links/rechts)
Der automatisch generierte Dateiname enthaelt den Unix-Zeitstempel
Im Dateikopf stehen der Dateiname,Baustelle!!!
In den Datenfeldern stehen vorzeichenbehaftete dB-Werte mit 2 Nachkommstellen.
Feldtrenner ist das Komma.

Nach jedem Schreiben eines Messwertes in die Datei erfolgt ein "flush", 
sodass nach einem Programmabbruch keine Daten verloren gehen. 

Der profiler misst Programmlaufzeiten, wobei der jeweils aktuelle Hoechststand ausgegeben wird ("peak hold")

todo

peak-hold-Anzeige als schmaler Balken mit Wert-Anzeige
1khz-Tonausgabe fuer Kalibrierung
erweiterter Dateiheader: Messwertrate
sauberer Programmausstieg, mit Datei schliessen
das plotFenster rechts positionieren
FFT-Ausgabe
Kurvenverlaufs-Ausgabe
"""
import pyaudio
import time
import mylib

# Datei-Operationen
FILE_PREFIX_L = 'RMSLeft'
FILE_PREFIX_R = 'RMSRight'
FILE_EXT = 'csv'
FIELD_SEPARATOR =','

# Audiosignal-Parameter
STREAM_CHANNELS = 2
STREAM_SAMPLE_RATE = 44100 
STREAM_FORMAT = pyaudio.paInt16
# Datenpuffer-Multiplikator
CHUNK_BUFFERS = 15  #!!!                                 

# Butterworth Bandpassfilter
BPLOWCUT = 950.0
BPHIGHCUT = 1050.0
BPORDER = 5

# peak hold
PEAK_HOLD_SEC = 3
PEAK_HOLD_MIN = -200

# "soft gain" zur Pegel-Kalibrierung!!!
GAINLEFT = 23.3
GAINRIGHT = 9.5

# plot-Ausgaben
XMIN = 0
XMAX = 1
YMIN = -120
YMAX = 0
TITLE = "Stereo Audio Spitzen-Pegelmesser, 1kHz-Filter, Abtastrate %dHz"%(STREAM_SAMPLE_RATE)
COMPRESS = CHUNK_BUFFERS                                      

def callback_2buffered (in_data, frame_count, time_info, status):
    global RawData, DataReady, BufferCount, ChunkBuffer, FrameCount
    # multi-chunk Datenpuffer ist voll:
    if BufferCount==0:
        if DataReady==True:
            print "!warning: 1 buffer may or may not have been lost!"
        # doppelt gepuffert weg schreiben und
        ChunkBuffer = RawData
        # sofort neue Daten abholen
        RawData = in_data
        DataReady = True
        BufferCount = CHUNK_BUFFERS
    else:
        # einen chunk an den multi-chunk-Puffer anhaengen
        RawData += in_data
    # Uebergabe an den naechsten callback-Aufruf  
    BufferCount = BufferCount - 1 
    # Uebergabe an das Hauptprogramm
    FrameCount = frame_count
    # Uebergabe an PyAudio
    return (in_data, pyaudio.paContinue)

#   Hauptprogramm Initialisierung

p = pyaudio.PyAudio()
CardId = mylib.GetDefaultInputDevice()
print "Card id = %d"%CardId
# Starte mit einem vollen DatenPufferzyklus 
BufferCount = CHUNK_BUFFERS
RawData = ""
DataReady = False
# erzeuge PegelDatei(en) mit TextKopf
TimeStamp = time.strftime("%Y-%b-%d-%Hh-%Mm-%Ss", time.gmtime())
FileNameL = FILE_PREFIX_L + TimeStamp + '.' + FILE_EXT
FileNameR = FILE_PREFIX_R + TimeStamp + '.' + FILE_EXT
FileLeft = mylib.FileInit(FileNameL, FileNameL, FIELD_SEPARATOR)
FileRight = mylib.FileInit(FileNameR, FileNameR, FIELD_SEPARATOR)
# aendert sich nicht zu Laufzeit, deshalb nur 1x beim Start, spart dann 20ms Laufzeit 
CoeffB, CoeffA = mylib.GetBpCoefficients(STREAM_SAMPLE_RATE, BPLOWCUT, BPHIGHCUT, BPORDER)
# initialisiere peak-hold-ticker
TickStart = mylib.NSecTickerInit()
TickRemainder = 0
NewTick = False
# initialisiere Messwerte
RmsL = RmsR = 0
MaxHoldL = MaxHoldR = PEAK_HOLD_MIN
MaxHoldLtmp = MaxHoldRtmp = PEAK_HOLD_MIN 
# initialisiere die plot-Ausgabe
RectBot,RectPeak,Fig = mylib.PlotLRBargraphInit(XMIN,XMAX,YMIN,YMAX,TITLE)
#RectBot,RectMid,RectTop,RectPeak,Fig = mylib.PlotLRBargraph2Init(RmsL,RmsR,XMIN,XMAX,YMIN,YMAX,LIMIT1,LIMIT2,TITLE)
# starte Audio-Stream
InputStream = p.open(
    format=STREAM_FORMAT,
    channels=STREAM_CHANNELS,
    rate = STREAM_SAMPLE_RATE,
    input_device_index=CardId,
    input=True,
    output=False,
    stream_callback=callback_2buffered) 
InputStream.start_stream()
# initialisiere debugging Ausgabe Laufzeitmessung 
MaxPgmTime = 0

#   Hauptprogramm Schleife

while InputStream.is_active():
    # zyklische Auffrischung mit der Wiederholrate = (F)rames (P)er (S)econd
    if DataReady==True:
        #StartPgmLoop = mylib.ProfilerStart()
        DataReady = False
        # transformiere int16 raw data -> float32 stereo array
        ChunkBuffer = mylib.Chunk2FloatArray(ChunkBuffer, FrameCount, CHUNK_BUFFERS, STREAM_CHANNELS)
        # filtere den Datenstrom durch ein Butterworth Bandpassfilter
        DataL, DataR = mylib.NoFilter(ChunkBuffer, CoeffB, CoeffA)	
        DataL, DataR = mylib.StereoBpFilter(ChunkBuffer, CoeffB, CoeffA)	
        # den mittleren Pegel messen ueber einen multi-chunk buffer
        RmsL, RmsR, MaxHoldLtmp, MaxHoldRtmp = mylib.StereoRmsMeter(DataL, DataR, MaxHoldLtmp, MaxHoldRtmp)
        # Pegelkalibrierung mittels "soft gain"!!!
	RmsL = RmsL + GAINLEFT
	RmsR = RmsR + GAINRIGHT
        # MaxHold zyklisch auffrischen, doppelt gepuffert
        NewTick, TickRemainder = mylib.NSecTicker(PEAK_HOLD_SEC, TickStart,  TickRemainder, NewTick) 
        if NewTick==True:
            NewTick = False
            # Uebernahme aktueller Max Hold
            print "linker Kanal (dB FS): %0.2f      rechter Kanal (dB FS): %0.2f"%(RmsL,RmsR)
            # Neustart Max Hold
            MaxHoldL, MaxHoldR = MaxHoldLtmp, MaxHoldRtmp
            MaxHoldLtmp = MaxHoldRtmp = PEAK_HOLD_MIN 
        # haenge Daten an PegelDatei(en) an
        dataL = "%0.2f"%RmsL 
        dataR = "%0.2f"%RmsR 
        mylib.FileAppend(FileLeft, dataL, FIELD_SEPARATOR)
        mylib.FileAppend(FileRight, dataR, FIELD_SEPARATOR)
        # aktualisiere die plot-Ausgabe
        mylib.PlotLRBargraph(RmsL, RmsR, MaxHoldL, MaxHoldR, YMIN, RectBot, RectPeak, Fig)
        #MaxPgmTime = mylib.ProfilerStop(StartPgmLoop, MaxPgmTime)
        # minimiere polling-Last
    else:
        time.sleep(0.005)

#   Hauptprogramm Ende

InputStream.stop_stream()
InputStream.close()
p.terminate()


