#! /usr/bin/python2.7

import pyaudio
import time
import numpy as np
import mylib

#   Konfiguration

#   Audiosignal-Parameter
PLAY_CHANNELS = 1 
PLAY_SAMPLE_RATE = 44100
PLAY_FORMAT = pyaudio.paInt16
#   Tongenerator
PLAY_TONE_FQ = 1100.0
PLAY_TONE_LEVEL = 1/3.85	#0.5
PLAY_CHUNK_LEN = 1024 #!!!

#    callback Funktion

def callback_tonegen (out_data, frame_count, time_info, status):
    global NextChunk
    if NextChunk == True:
        print "!Fehler:output-chunk verloren!"
    # Handshake-Uebergabe an Hauptprogramm
    NextChunk = True
    # PhasenSprungKorrektur durch ArrayIndexOffset ("slicing")
    Data = DoubleChunkBuf[PhaseIdx::]
    return (Data, pyaudio.paContinue)

#   Hauptprogramm Initialisierung

#   Befuelle Chunk-Puffer mit Sinus-Schwingungen
Phase = 0.0
PhaseIdx = 0
NextChunk = False
DoubleChunkBuf, PhaseOfs, MaxPhase = mylib.DoubleChunkInit(PLAY_TONE_FQ, PLAY_TONE_LEVEL, PLAY_SAMPLE_RATE, PLAY_CHUNK_LEN)
print "MaxPhase=%f PhaseOfs=%f"%(MaxPhase,PhaseOfs)

#   initialisiere die Soundkarte
p = pyaudio.PyAudio()
CardId = mylib.GetDefaultInputDevice()
print "Card id = %d"%CardId

#   starte Audio-Stream
OutputStream = p.open(
    format=PLAY_FORMAT,
    channels=PLAY_CHANNELS,
    rate = PLAY_SAMPLE_RATE,
    input=False,
    output=True,
    output_device_index=CardId,
    stream_callback=callback_tonegen) 
OutputStream.start_stream()

#   Hauptprogrammschleife

while OutputStream.is_active():
#while 1==1:
    if NextChunk == True:
        NextChunk = False
        # Versatz fuer PhasenSprungKorrektur
        TmpChunkBuf = DoubleChunkBuf[PhaseIdx::]
        #print "phase=%f Start Value=%d Stop Value=%d Index=%d"%(Phase,TmpChunkBuf[0],TmpChunkBuf[1023],PhaseIdx)
        Phase += PhaseOfs
        Phase = Phase % (4 * np.pi) #!!!
        PhaseIdx = int(Phase * PLAY_CHUNK_LEN / (MaxPhase))
    time.sleep(0.001)

#   Programmende

OutputStream.stop_stream()
OutputStream.close()
p.terminate()

